//Source file: F:\jschwartz\src\Alkindi\BusinessServices\IAccountManager.java

/* Copyright (C) 2000 Alikindi, LLC */

package Alkindi.Services;

import Alkindi.Data.AccountInfo;
import Alkindi.Data.SystemUser;
import java.rmi.RemoteException;
import Alkindi.Data.MyList;

/* 
$Header: IAccountManager.java, 11, 12/28/00 8:09:05 PM, Schwartz, Joe$
$Log: 
 11   Alkindi Development1.10        12/28/00 8:09:05 PM  Schwartz, Joe  
      Changed members for which return value doesn't matter to return void. 
 10   Alkindi Development1.9         12/28/00 2:41:56 PM  Schwartz, Joe  
      Standardized methods to use final parameters and fully-qualified types
      where necessary. Makes Rose happy.
 9    Alkindi Development1.8         12/28/00 1:07:06 PM  Schwartz, Joe   Added
      Version Control header info.
 8    Alkindi Development1.7         12/26/00 6:57:10 PM  Schwartz, Joe   
 7    Alkindi Development1.6         11/11/00 4:58:19 PM  Schwartz, Joe  
      Chagned to use MyList management classes.
 6    Alkindi Development1.5         11/4/00 3:58:52 PM   Schwartz, Joe   Added
      default values to fields.

 5    Alkindi Development1.4         10/19/00 1:12:03 PM  Schwartz, Joe   After
      10.19 Appian Delivery
 4    Alkindi Development1.3         10/9/00 3:12:08 PM   Schwartz, Joe   
 3    Alkindi Development1.2         10/6/00 4:13:36 PM   Schwartz, Joe   
 2    Alkindi Development1.1         9/24/00 3:12:15 PM   Schwartz, Joe   
 1    Alkindi Development1.0         9/21/00 4:12:04 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * This interface provides account creation and validation. It is also used to locate individual members of the system.
 */
public interface IAccountManager 
{
	
	/**
	 * Adds the given product to the specified user's MyList.
	 * @roseuid 39FF317601E4
	 */
	public void addToMyList(final Alkindi.Data.SystemUser user, final Alkindi.Data.Product product) throws RemoteException,AlkExcept;
	
	/**
	 * Transforms the given SystemUser into a full Alkindi member.
	 * @roseuid 39C13D15036B
	 */
	public void createMember(final Alkindi.Data.SystemUser user, Alkindi.Data.AccountInfo acctInfo) throws RemoteException,AlkExcept;
	
	/**
	 * Creates a SystemUser. This is done when a New User begins the process of submitting ratings in order to become a full member.
	 * @roseuid 39C13CEE00BB
	 */
	public Alkindi.Data.SystemUser createUser() throws RemoteException,AlkExcept;
	
	/**
	 * This retrieves the AccountInfo object for the given SystemUser.
	 * @roseuid 39C13E9D03C8
	 */
	public Alkindi.Data.AccountInfo getAccountInfo(final Alkindi.Data.SystemUser user) throws RemoteException,AlkExcept;
	
	/**
	 * Retrieves the specified user's MyList as a ProductList.
	 * @roseuid 39FF31840271
	 */
	public Alkindi.Data.MyList getMyList(final Alkindi.Data.SystemUser user) throws RemoteException,AlkExcept;
	
	/**
	 * This returns a list of alternative validation questions for the user with the specified login. The return value is a vector of Integer objects.
	 * @roseuid 39C13DF101D4
	 */
	public int[] getQuestions(final java.lang.String login) throws RemoteException,AlkExcept;
	
	/**
	 * @roseuid 3A0BFC3B032C
	 */
	public java.lang.String getScreenName(final Alkindi.Data.SystemUser user) throws RemoteException,AlkExcept;
	
	/**
	 * Removes the given product from the specified user's MyList.
	 * @roseuid 39FF31FD02AF
	 */
	public void removeFromMyList(final Alkindi.Data.SystemUser user, final Alkindi.Data.Product product) throws RemoteException,AlkExcept;
	
	/**
	 * This updates the AccountInfo for the given SystemUser with the values provided.
	 * @roseuid 39C13ED2000F
	 */
	public void updateMember(final Alkindi.Data.SystemUser user, Alkindi.Data.AccountInfo acctInfo) throws RemoteException,AlkExcept;
	
	/**
	 * Changes the account status of the given SystemUser to the status provided.
	 * @roseuid 39AC2FC40109
	 */
	public void updateUserStatus(final Alkindi.Data.SystemUser user, final int newStatus) throws RemoteException,AlkExcept;
	
	/**
	 * Checks that the supplied login and password match
	 * @roseuid 399D9A13036B
	 */
	public Alkindi.Data.SystemUser validateUser(final java.lang.String login, final java.lang.String password) throws RemoteException,AlkExcept;
	
	/**
	 * Checks that the given login matches the supplied answers to additional validation questions. If the validation fails, this function generates a new password and email the user.
	 * @roseuid 39C13DAD02BF
	 */
	public Alkindi.Data.SystemUser validateUserQuestions(final java.lang.String login, final int question1, final java.lang.String answer1, final int question2, final java.lang.String answer2) throws RemoteException,AlkExcept;
}
